# Copyright 2020 Autodesk, Inc.  All rights reserved.
#
# Use of this software is subject to the terms of the Autodesk license
# agreement provided at the time of installation or download, or which
# otherwise accompanies this software in either electronic or hard copy form.

from ctypes import *
from .arnold_common import ai
from .ai_types import *
from .ai_metadata import AtMetadataStore
from .ai_universe import AtUniverse
from .ai_map import AtParamValueMap

def _AiSceneLoad(universe, filename, params):
    func = ai.AiSceneLoad
    func.argtypes = [POINTER(AtUniverse), AtPythonString, POINTER(AtParamValueMap)]
    func.restype = c_bool

    return func(universe, filename, params)

def AiSceneLoad(*args):
    return _AiSceneLoad(*args) if args[0] is None or type(args[0]) == POINTER(AtUniverse) else _AiSceneLoad(None, *args)

def _AiSceneWrite(universe, filename, params, mds = None):
    func = ai.AiSceneWrite
    func.argtypes = [POINTER(AtUniverse), AtPythonString, POINTER(AtParamValueMap), POINTER(AtMetadataStore)]
    func.restype = c_bool

    return func(universe, filename, params, mds)

def AiSceneWrite(*args):
    return _AiSceneWrite(*args) if args[0] is None or type(args[0]) == POINTER(AtUniverse) else _AiSceneWrite(None, *args)

def AiSceneFormatSupported(extension):
    func = ai.AiSceneFormatSupported
    func.argtypes = [AtPythonString]
    func.restype = c_bool

    return func(extension)
